#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../module/database/OracleUtility'

describe '[Story# VAR-1923: Booked Appointment - Cancel Appointment]
          [Story# VAR-3061: Direct Appointment - Add Reason for Cancellation]' do
  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @db = connectToMongoDB("var-utility")

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y @ 09:00")
    @twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y @ 09:00")
    @thirtyDaysLater = getDateNthDaysFromNow(30, "%m/%d/%Y @ 09:00")
    @thirtyOneDaysLater = getDateNthDaysFromNow(31, "%m/%d/%Y @ 09:00")
    @sevenDaysLater = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @@timeSlot = "11:00"
    @friendly_name = "Facility Friendly Text"
    @clinic_friendly_name ="JP PRIMARY CARE DR. CREAMER"
    @location = "BOSTON HCS VAMC"
    @clinic = PRIMARY_CARE.upcase.strip
    #cancel existing appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysLater} 11:00:00")
    @cancel_appointment.cancel_appointment()
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    deletePatientData("1113138327")
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
    @common.selectAddAppointmentButton("VA")
    @@cc_enabled = @common.ccEnabled
    @new_appointment.createAppointment(PRIMARY_CARE, '523', '32', 'test', @sevenDaysLater, @@timeSlot, 'testAutomation@testAutomationxyz.com')
    @@setDate = NewAppointmentRequest.bookedDate
    button_element = @driver.button(:id => 'back-btn')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    @common.waitWhileSpinnerPresent

  end

  after(:all) do

    @driver.close
  end

  context "AC# VAR-2049|TC# VAR-2235: Booked Appointment - Cancel Appointment
           AC# VAR-3165|TC# VAR-3166: Direct Appointment - Add Reason for Cancellation" do

    it "Should open apointment details and verify cancel appointment buttoon is present" do
      @landing_appointments.refresh
      @common.waitWhileSpinnerPresent
      sleep 2
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing_appointments.appointment_table_list_elements.length >= 1}
      @@selectedDay = getDayofWeek(@@setDate)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_select = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate}" + "\n" + "#{@@timeSlot}" + "\n" + "#{@@selectedDay}, #{@@setDate} #{@@timeSlot.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@location}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      @landing_appointments.openIfAppointmentExists(all_appointments, appointment_to_select)
      @common.waitWhileSpinnerPresent
      expect(@detail.cancel_appointment?).to eq(true)
    end

    it "should verify Cancel Appointment button text" do
      expect(@detail.cancel_appointment_element.text).to eq("Cancel Appointment")
    end

    it "Should verify Cancel Appointment Modal is displayed" do
      @detail.clickCancelAppointment
      expect(@modal.modalTitle).to eq('Cancel Appointment')
    end

    it "Should verify details on the Cancel Appointment modal" do
      expected_text = [\
         "Cancel Appointment",
         "* required field",
         "* Reason for Cancellation",
         "Select",
         "DEATH IN FAMILY",
         "OTHER",
         "TRANSFER OPT CARE TO OTHER VA",
         "TRAVEL DIFFICULTY",
         "UNABLE TO KEEP APPOINTMENT",
         "WEATHER",
         "Confirm Cancellation",
         "Close without Cancelling"

      ]
      actual_text = @detail.cancel_reason_section_element.text.split("\n")
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)
      end
    end

    it "should verify close without cancelling return to appointment details" do
      @detail.clickCloseWithoutCancelling
      expect(@detail.has_expected_title?).to eq(true)
    end

    it "should verify Reason for Cancellation is required" do
      @detail.clickCancelAppointment
      @detail.clickConfirmCancellation
      verifyErrorMessage("Reason for Cancellation field is required.")
    end

    it "Should verify Cancel Appointment button, confirmation modal" do
      @detail.selectReasonForCancellation("TRANSFER OPT CARE TO OTHER VA")
      sleep 2
      @detail.clickConfirmCancellation
      expect(@modal.modalTitle).to eq('Appointment Cancelled')
    end

    it "should verify Appointment Cancelled Modal content" do
      expect(@modal.content_element.text).to eq("Your appointment has been successfully cancelled.  It will no longer be visible in your appointment list.")
    end

    it "Should Verify a button with text 'OK' exists" do
      expect(@modal.buttons_elements[0].text).to eq("OK")
    end

    it "Should verify OK button, selecting closes the modal, navigates back to appointment list" do
      @modal.buttons_elements[0].click
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.has_expected_title?).to eq(true)
    end

    it "Verify resizing window to iPhone display removes back button label" do
      resizeWindowToPhone()
      Watir::Wait.until {@landing_appointments.appointment_btn_label == ""}
      expect(@landing_appointments.appointment_btn_label).to eq("")
    end

  end
end









